//Exp 9 Program Title:To implement Block truncation coding on grayscale image and color image
//environment: Scilab 5.5.2
//Toolbox: Image Processing Design 8.3.1-1
//Toolbox: SIVP 0.5.3.2
//Tested on OS: Windows 7 Professional, 64 bit
//Reference books names : 1)Digital Image Processing book author :
// Rafael C.Gonzalez and Richard E.Woods,
//2)Digital Image Processing book author :S.Sudhir,
//3)Digital Image Processing book author :Dhanajay Theckedath
clc //to clear command window.
clear all //to disable previously defined variables.
xdel(winsid());///clear all the previous figures plots
SIVP_PATH = getSIVPpath(); //to locate a directory in which SIVP toolbox is installed
im1=imread(SIVP_PATH + 'images/rose.bmp');//read second color image from directory
im2=rgb2gray(im1);
im11=imresize(im1,[256,256]);// image resize
imd=double(im11);
im2=double(im2);
[red,green,blue]=colorplanes(imd);//Seperation of color planes
[gr,lmrgr,umrgr]=uplmean(im2);//BTC for graysacleimage
[r1,lmrr,umrr]=uplmean(red);//BTC for red plane
[g1,lmrg,umrg]=uplmean(green);//BTC for green plane
[b1,lmrb,umrb]=uplmean(blue);//BTC for blue plane
btcim=cat(3,r1,g1,b1);// formation of BTC image
btcim=uint8(btcim);
figure(1);ShowColorImage(im1,'Color image image');title('Color image','color','red','fontsize',6);
figure(2);ShowImage(gr,'Truncated grayscale image in upper mean and upper mean color values');title('Truncated grayscale image in upper mean and upper mean color values','color','red','fontsize',3);
figure(3);ShowColorImage(btcim,'Truncated image in upper mean and upper mean color values');title('Truncated image in upper mean and upper mean color values','color','red','fontsize',3);

